/****************************************************************************
 **                                                                        **
 **  "Oblivion" experimental raytracing engine - Aron, 1998.07.15          **
 **                                                                        **
 ****************************************************************************/

// - konstansok -------------------------------------------------------------
#include "compile.h"

#ifdef RAYTRACER_LOWRESOLUTION
#define  X_RESOLUTION           80
#define  Y_RESOLUTION           45
#elif defined(RAYTRACER_HIGHRESOLUTION)
#define  X_RESOLUTION           160
#define  Y_RESOLUTION           90
#else
#define  X_RESOLUTION           320
#define  Y_RESOLUTION           180
#endif

#define  MAX_RECURSION_LEVEL    3
#define  OBJECT_PRIMITIVES      4

#define  INFINITE_DISTANCE      1000.0*1000.0
#define  PHONG_EXPONENT         32
#define  FOG_DISTANCE_MIN       300.0
#define  FOG_DISTANCE_MAX       400.0
#define  REFRACTION_FACTOR      0.8

// sugartorzitas kodjai:
enum ray_perturbance { NOT_USE_RAY_PERTURBANCE, USE_RAY_PERTURBANCE };

// object primitivek kodjai:
enum object_primitive_code { TPLANE= 0, TSPHERE, TCYLINDER, TPOLYGON };

// metszes kodok:
enum intersection_code { BOOLEAN_INTERSECTION= 0, EXACT_INTERSECTION };

// surfacetype flag-ek:
enum surface_type { DISTANCE_SHADED= 0, PHONG_SHADED= 1,
                    NON_SHADOWED= 0, SHADOWED= 2,
                    NON_REFLECTIVE= 0, REFLECTIVE= 4,
                    NON_REFRACTIVE= 0, REFRACTIVE= 8,
                    NON_FLIPPED= 0, FLIPPED= 16 };
enum fog_code { NON_FOGGED= 0, FOGGED= 1 };

// - altalanos strukturak ---------------------------------------------------
typedef struct { float X,Y,Z;
               } VECTOR;

typedef struct { byte type;                 // objektum tipus (sik/gomb)
                 void *data;                // leiro adatokra mutato
                 byte *textureptr;          // szin
                 byte surfacetype;          // felulettipus
               } OBJECT;

typedef struct { VECTOR position;           // kamera pozicio
                 VECTOR target;             // nezopont
                 float FOV,roll;            // latoszog es roll szog
               } CAMERA;

typedef struct { float t;                   // metszesponthoz tartozo t parameter
                 VECTOR point;              // metszespont
                 VECTOR normal;             // metszespontbeli normalis
                 OBJECT *objectptr;         // metszett objektumprimitiv indexe
                 byte *textureptr;          // metszespont texturajara mutato
                 byte surfacetype;          // metszespont felulettipusa
                 dword U,V;                 // mapping koordinatak
               } INTERSECTION;

typedef struct { VECTOR Pstart;             // kezdopont
                 VECTOR D;                  // iranyvektor
               } RAY;

typedef struct { VECTOR position;           // omni fenyforras helyvektora
               } OMNI_LIGHTSOURCE;

// - objektum primitivek ----------------------------------------------------
typedef struct { VECTOR onepoint;           // egy sikbeli pont
                 float D;
               } PLANE;

typedef struct { VECTOR center;             // kozeppont
                 float radius;              // sugar
               } SPHERE;

typedef struct { VECTOR A,B;                // fedolapok kozeppontjai
                 float radius;              // sugar
                 VECTOR axis;
                 float axis2;
               } CYLINDER;

typedef struct { VECTOR A,B,C;              // csucsok helyvektorai
                 VECTOR normal;
                 VECTOR B1,B2;
               } POLYGON;

// - interface --------------------------------------------------------------
void TraceScene(byte *,CAMERA *,OMNI_LIGHTSOURCE *,dword);

void SetupSpheresScene(byte *);
void AnimateSpheresScene(float);

void SetupCubeScene(byte *);
void AnimateCubeScene(float);

void SetupMirrorBallScene(byte *tbuffer);
void AnimateMirrorBallScene(float);

void SetupPipeScene(byte *);

void SetupColumnsScene(byte *tbuffer);
